<?php

namespace Dmkzwo\ContaoElementsBundle\Elements;

use Contao\ContentModel;
use Contao\FilesModel;
use Contao\Controller;
use Contao\System;
use Contao\CoreBundle\Controller\ContentElement\AbstractContentElementController;
use Contao\CoreBundle\ServiceAnnotation\ContentElement;
use Contao\Template;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Contao\FrontendTemplate;

/**
 * @ContentElement(QuoteElementController::TYPE)
 */
class QuizElementController extends AbstractContentElementController
{
    public const TYPE = 'quiz_element';

    protected $template;
    protected $model;

    protected $baseCssClass = 'ce_dzquiz';
    protected $numPages;


    protected function getResponse(Template $template, ContentModel $model, Request $request): ?Response
    {
        $this->model = $model;
        $this->template = $template;

        $template->baseCssClass = $this->baseCssClass;

        $keycolor = !empty($model->dzGeneralKeycolor) ? $model->dzGeneralKeycolor : 'standard';
        $template->keycolorClass = $this->baseCssClass . '--keycolor-' . $keycolor;

        $xmlStr = str_replace('&lt;', '<', $model->dzQuiz);

        $output = '';
        $altText = '';
        $altText .= '<h2>' . $template->headline . '</h2>';

        if (TL_MODE == 'FE') {

//            echo '<pre>' . $xmlStr . '</pre>';

            $xmlObj = new \SimpleXMLElement($xmlStr);

            $this->numPages = sizeof($xmlObj->page);

            $pageCounter = 0;

            $pageObjs = [];

            foreach ($xmlObj->page as $pageObj) {
                $pageObjs[] = $pageObj;
            }

            shuffle($pageObjs);

            foreach ($pageObjs as $pageObj) {
                $output .= $this->parsePage($pageObj, $pageCounter);
                $altText .= $this->getPageAltText($pageObj, $pageCounter);
                $pageCounter++;
            }
        }

        $altText .= $model->dzQuizAlt;

        $template->output = $output;
        $template->altText = $altText;


        return $template->getResponse();
    }

    protected function parsePage($pageObj, $pageCounter): string
    {
        $pageTemplate = new FrontendTemplate('quiz_page');

        $pageTemplate->baseCssClass = $this->baseCssClass;

        $addClass = '';
        $addClass .= ($pageCounter == 0) ? ' active' : '';
        $addClass .= ($pageCounter == ($this->numPages - 1)) ? ' last' : '';
        $pageTemplate->addClass = $addClass;

        $pageTemplate->isLast = ($pageCounter == ($this->numPages - 1));
        $pageTemplate->question = $pageObj->question;
        $pageTemplate->answer = $pageObj->answer;
        $pageTemplate->options = $pageObj->options;
        $pageTemplate->headline = $this->template->headline;
        $pageTemplate->hl = $this->template->hl;

        $objModel = FilesModel::findByUuid("" . $pageObj->img);

        if ($objModel !== null && is_file(System::getContainer()->getParameter('kernel.project_dir') . '/' . $objModel->path))
        {
            $pageTemplate->imageSrc = $objModel->path;
            Controller::addImageToTemplate($pageTemplate, null, null, null, $objModel);
        }

        return $pageTemplate->parse();
    }

    protected function getPageAltText($pageObj, $pageCounter): string
    {
        $altText = '';
        $optionCounter = 0;
        $correctAnswer = '';

        $altText .= '<h3>' . $pageObj->question . '</h3>';

        $altText .= sprintf('<p>%s:</p><ul>', $GLOBALS['TL_LANG']['dzquiz']['possibleAnswers']);
        foreach ($pageObj->options->option as $option) {
            $letter = chr(65 + $optionCounter);
            if ($option->correct) {
                $correctAnswer = $letter;
            }
            $optionCounter++;
            $altText .= sprintf('<li>%s: %s</li>', $letter, $option->label);
        }
        $altText .= '</ul>';

        $altText .= sprintf('<p>%s: ' . $correctAnswer . '</p>',   $GLOBALS['TL_LANG']['dzquiz']['correctAnswer']);
        if ($pageObj->answer) {
            $altText .= sprintf('<p>%s: ' . $pageObj->answer . '</p>', $GLOBALS['TL_LANG']['dzquiz']['explanation']);
        }

        return $altText;
    }

}


