import {CustomModal, initPrivacy} from "Components/custom-modal";

var dzvideo = (function () {

    var init = function () {
        addEventListeners();
        return;
    };

    var addEventListeners = function () {
        $('.ce_dzquiz')
            .on('click', '.js-quiz-option', handleAnswer)
            .on('click', '.js-quiz-next', handleNext);

        $('.ce_dzquiz-alt')
            .on('click', '.js-quiz-alt-toggle', handleAltToggle);
    }

    var handleAnswer = function(event) {
        var $this = $(this);

        var $actPage = $this.closest('.js-quiz-page');

        $actPage.addClass('pending');
        $actPage.find('.js-quiz-option').attr('disabled', '')

        setTimeout(function() {
            $actPage.addClass('answered').removeClass('pending');
            $actPage.find('.js-quiz-next').attr('tabindex', '0');

            $this.addClass('answer');

        }, 2000);

    }

    var handleNext = function(event) {
        var $this = $(this);

        var $actPage = $this.closest('.js-quiz-page');

        $actPage.removeClass('active');
        $actPage.next().addClass('active');
        // $actPage.find('.js-quiz-next').attr('tabindex', '0');

    }

    var handleAltToggle = function(event) {
        console.log('click');
        var $this = $(this);

        if ($this.attr('aria-expanded') === 'false') {
            $this.attr('aria-expanded', true);
        } else {
            $this.attr('aria-expanded', false);
        }
        $this.find('+ div').slideToggle();
    }

    return {
        init: init
    }

})();

dzvideo.init();

