<?php

namespace Dmkzwo\ContaoElementsBundle\Elements;

use Contao\ContentModel;
use Contao\FilesModel;
use Contao\Controller;
use Contao\System;
use Contao\CoreBundle\Controller\ContentElement\AbstractContentElementController;
use Contao\CoreBundle\ServiceAnnotation\ContentElement;
use Contao\Template;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;

/**
 * @ContentElement(QuoteElementController::TYPE)
 */
class QuoteElementController extends AbstractContentElementController
{
    public const TYPE = 'quote_element';

    protected $template;
    protected $model;

    protected $baseCssClass = 'ce_dzquote';


    protected function getResponse(Template $template, ContentModel $model, Request $request): ?Response
    {
//        $themeFolder = \System::getContainer()->getParameter('theme_folder');
//
//        if (TL_MODE == 'FE') {
//            $templateName = 'ce_quote_element_' . $model->dzSubtype;
//            $templateFile = sprintf(TL_ROOT . '/templates/%s/%s.html5', $themeFolder, $templateName);
//
//            if (file_exists($templateFile)) {
//                $template = $this->createTemplate($model, 'ce_quote_element_' . $model->dzSubtype);
//            }
//        }

//        if ($model->dzSubtype != 'standard') {
//            echo '...';
//            var_dump($model->customTpl);
//            $model->customTpl = 'ce_quote_element_' . $model->dzSubtype;
//        }

//        if ($model->dzSubtype != 'standard') {
//            try {
//                $template = $this->createTemplate($model, 'ce_quote_element_' . $model->dzSubtype);
//
//                $this->addHeadlineToTemplate($template, $model->headline);
//                $this->addCssAttributesToTemplate($template, 'ce_'.$type, $model->cssID, $classes);
//                $this->addPropertiesToTemplate($template, $request->attributes->get('templateProperties', []));
//                $this->addSectionToTemplate($template, $section);
//                $this->tagResponse(['contao.db.tl_content.'.$model->id]);
//            } catch(\Exception $e) {
//
//            }
//        }

        $template->baseCssClass = $this->baseCssClass;

        $keycolor = !empty($model->dzGeneralKeycolor) ? $model->dzGeneralKeycolor : 'standard';
        $template->keycolorClass = $this->baseCssClass . '--keycolor-' . $keycolor;

        $template->addImage = false;

        // Add an image
        if ($model->addImage && $model->singleSRC != '')
        {
            $template->addImage = true;
            $objModel = FilesModel::findByUuid($model->singleSRC);

            if ($objModel !== null && is_file(System::getContainer()->getParameter('kernel.project_dir') . '/' . $objModel->path))
            {
                $model->singleSRC = $objModel->path;
                Controller::addImageToTemplate($template, $model->row(), null, null, $objModel);
            }
        }
//
//        $this->template = $template;
//        $this->model = $model;

        return $template->getResponse();
    }


}

