<?php

declare(strict_types=1);

namespace Dmkzwo\ContaoDzHelperBundle\Twig;

use Dmkzwo\ContaoDzHelperBundle\Model\CountryModel;
use Twig\Extension\AbstractExtension;
use Twig\TwigFilter;

class CountryExtension extends AbstractExtension
{
    #[\Override]
    public function getFilters(): array
    {
        return [
            new TwigFilter('countryLabel', $this->countryLabel(...)),
        ];
    }

    public function countryLabel(string $identifier, string $lang = ''): string
    {
        if (preg_match('/^[a-z]{3}$/', $identifier)) {
            // iso3
            $country = CountryModel::findOneByIso($identifier);

            if ($country) {
                return $country->nameLang;
            }
        } elseif (preg_match('/^[a-z]{2}$/', $identifier)) {
            // iso2
            $country = CountryModel::findOneByIso2($identifier);

            if ($country) {
                return $country->getNameLang();
            }
        } elseif (\is_int($identifier)) {
            // ID
            $country = CountryModel::findOneById($identifier);

            if ($country) {
                return $country->getNameLang();
            }
        }

        return 'country not found';
    }
}
