<?php

declare(strict_types=1);

namespace Dmkzwo\ContaoDzHelperBundle\Model;

use Contao\Model;

class CountryModel extends Model
{
    protected static $strTable = 'tl_dz_country';

    public static function getLUT(): array
    {
        $lut = [];

        $allCountries = static::findAll();

        foreach ($allCountries as $country) {
            $lut[$country->id] = $country->name;
        }

        return $lut;
    }

    public function getNameLang(): string
    {
        $fieldName = 'name'.ucfirst((string) $GLOBALS['TL_LANGUAGE']);

        return $this->$fieldName ?: $this->nameDe;
    }
}
