<?php

declare(strict_types=1);

namespace Dmkzwo\ContaoDzHelperBundle\Classes;

use Contao\Backend;
use Contao\Image;
use Contao\StringUtil;

class DcaHelper extends Backend
{
    public function pasteEntry($dc, $row, $table, $cr, $arrClipboard = false)
    {
        $labelPasteAfter = 'einfügen'; // TODO: translate properly
        $labelPasteInto = 'einfügen';

        $imagePasteAfter = Image::getHtml('pasteafter.gif', $labelPasteAfter);
        $imagePasteAfterDisabled = Image::getHtml('pasteafter_.gif', $labelPasteAfter);
        $imagePasteInto = Image::getHtml('pasteinto.gif', $labelPasteInto);
        $imagePasteIntoDisabled = Image::getHtml('pasteinto_.gif', $labelPasteInto);

        if (0 === $row['id']) {
            // root paste

            if ($cr) {
                return $imagePasteIntoDisabled.' ';
            }

            return '<a href="'.$this->addToUrl(
                'act='.$arrClipboard['mode'].'&mode=2&pid='.$row['id'].'&id='.$arrClipboard['id'],
            ).'" title="'.StringUtil::specialchars($labelPasteInto).'" onclick="Backend.getScrollOffset();">'.$imagePasteInto.'</a> ';
        }

        if (('cut' === $arrClipboard['mode'] && $arrClipboard['id'] === $row['id']) || $cr) {
            // disabled for source row
            return $imagePasteAfterDisabled;
        }

        return '<a href="'.$this->addToUrl('act='.$arrClipboard['mode'].'&mode=1&pid='.$row['id']).'" title="'.StringUtil::specialchars($labelPasteAfter).'" onclick="Backend.getScrollOffset()">'.$imagePasteAfter.'</a> ';
    }

    //    public function generateProjectAlias($varValue, DataContainer $dc)    {
    // $varValue = $this->generateAlias($varValue, $dc, 'tl_dzhelper_project',
    // 'title', 'alias');         return $varValue;    }     public function
    // generateAlias($varValue, DataContainer $dc, string $tableName, string
    // $sourceField, string $targetField)    {        $aliasExists = static function
    // (string $alias) use ($dc, $tableName, $targetField): bool {            $result
    // = Database::getInstance()                ->prepare("SELECT id FROM " .
    // $tableName . " WHERE " . $targetField . "=? AND id!=?") ->execute($alias,
    // $dc->id);             return $result->numRows > 0;        };         $options
    // = [ /            'locale' => 'de', /            'validChars' => $validChars,
    // ];         // Generate alias if there is none        if (!$varValue) {
    // $varValue =
    // System::getContainer()->get('contao.slug')->generate($dc->activeRecord->$sourceField,
    // $options, $aliasExists);        } elseif (preg_match('/^[1-9]\d*$/',
    // $varValue)) {            throw new
    // \Exception(sprintf($GLOBALS['TL_LANG']['ERR']['aliasNumeric'], $varValue));  }
    // elseif ($aliasExists($varValue)) {            throw new
    // \Exception(sprintf($GLOBALS['TL_LANG']['ERR']['aliasExists'], $varValue)); } /
    //        dd($varValue);         return $varValue;    }     public function
    // getCategoryOptions(DataContainer $dc): array    {        $items =
    // TopicModel::findAll(['order' => 'sorting asc']);         $options = [];  if
    // ($items) {            foreach ($items as $item) { $options[$item->id] =
    // $item->titleDe;            }        }         return $options;    }
}
