<?php


declare(strict_types=1);

use Contao\Rector\Set\SetList;
use Rector\Config\RectorConfig;
use Rector\ValueObject\PhpVersion;

return RectorConfig::configure()
    ->withPaths([
        __DIR__ . '/src',
        __DIR__ . '/config',
        __DIR__ . '/tests',
    ])
    ->withSets([\Contao\Rector\Set\ContaoLevelSetList::UP_TO_CONTAO_53, \Rector\Set\ValueObject\LevelSetList::UP_TO_PHP_83, \Contao\Rector\Set\ContaoSetList::ANNOTATIONS_TO_ATTRIBUTES, \Rector\Doctrine\Set\DoctrineSetList::ANNOTATIONS_TO_ATTRIBUTES])        // Contao-specific rules
    ->withPhpVersion(PhpVersion::PHP_83) // align with your target PHP
    // ->withSymfonyContainerPhp('var/cache/dev/ContainerXYZ/getContainer.php') // optional for advanced Symfony rules

    ;
