<?php

use Contao\DC_Table;

$GLOBALS['TL_DCA']['tl_dz_country'] = [
    'config' => [
        'dataContainer' => DC_Table::class,
        'enableVersioning' => true,
        'sql' => [
            'keys' => [
                'id' => 'primary',
                'iso' => 'index',
                'iso2' => 'index',
            ],
        ],
        'list' => [
            'operations' => [
                'edit',
                'copy',
                'delete',
                'show',
            ]
        ]
    ],

    'list' => [
        'sorting' => [
            'mode' => 1,
            'flag' => 11,
            'fields' => ['nameDe'],
            'disableGrouping' => true,
            'panelLayout' => 'sort,filter;search,limit'
        ],
        'label' => [
            'fields' => ['iso', 'iso2', 'nameDe'],
            'showColumns' => true,
        ],

    ],

    'palettes' => [
        'default' => 'iso,iso2,oecd,nameDe,nameEn,nameEs,nameFr,namePt',
    ],

    'fields' => [
        'id' => [
            'sql' => "int(10) unsigned NOT NULL auto_increment"
        ],
        'tstamp' => [
            'sql' => "int(10) unsigned NOT NULL default '0'"
        ],
//        'published' => [
//            'toggle' => true,
//            'inputType' => 'checkbox',
//            'eval' => ['tl_class' => 'w50 m12'],
//            'sql' => ['type' => 'boolean', 'default' => true],
//        ],
        'iso' => [
            'inputType' => 'text',
            'eval' => ['mandatory' => true, 'tl_class' => 'clr w33', 'minLength' => 3, 'maxlength' => 3, 'rgxp' => 'custom', 'customRgxp' => '/^[a-z]{3}$/', 'errorMsg'=> 'nur Kleinbuchstaben'],
            'sql' => "char(3) NOT NULL default ''",
        ],
        'iso2' => [
            'inputType' => 'text',
            'eval' => ['mandatory' => true, 'tl_class' => 'w33', 'minLength' => 2, 'maxlength' => 2, 'rgxp' => 'custom', 'customRgxp' => '/^[a-z]{2}$/', 'errorMsg'=> 'nur Kleinbuchstaben'],
            'sql' => "char(2) NOT NULL default ''",
        ],
        'oecd' => [
            'inputType' => 'checkbox',
            'eval' => ['tl_class' => 'w33 m12'],
            'sql' => ['type' => 'boolean', 'default' => false],
        ],
        'nameDe' => [
            'inputType' => 'text',
            'eval' => ['mandatory' => true, 'tl_class' => 'clr long', 'maxlength' => 255],
            'sql' => "varchar(255) NOT NULL default ''",
        ],
        'nameEn' => [
            'inputType' => 'text',
            'eval' => ['mandatory' => true, 'tl_class' => 'clr long', 'maxlength' => 255],
            'sql' => "varchar(255) NOT NULL default ''",
        ],
        'nameEs' => [
            'inputType' => 'text',
            'eval' => ['mandatory' => true, 'tl_class' => 'clr long', 'maxlength' => 255],
            'sql' => "varchar(255) NOT NULL default ''",
        ],
        'nameFr' => [
            'inputType' => 'text',
            'eval' => ['mandatory' => true, 'tl_class' => 'clr long', 'maxlength' => 255],
            'sql' => "varchar(255) NOT NULL default ''",
        ],
        'namePt' => [
            'inputType' => 'text',
            'eval' => ['mandatory' => true, 'tl_class' => 'clr long', 'maxlength' => 255],
            'sql' => "varchar(255) NOT NULL default ''",
        ],

    ]
];

