<?php

declare(strict_types=1);

/*
 * This file is part of [dmkzwo/contao-hello-world-bundle].
 *
 * (c) Dmkzwo
 *
 * @license LGPL-3.0-or-later
 */

namespace Dmkzwo\ContaoDzConextBundle\Classes\Command;

use Contao\CoreBundle\Framework\ContaoFramework;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Console\Question\ConfirmationQuestion;
use Symfony\Component\Filesystem\Filesystem;

class AdditionsCommand extends DbBaseCommand
{
    private $rootDir;
    private $framework;

//    private $createTemplate;

    public function __construct(string $rootDir, ContaoFramework $framework)
    {
        $this->rootDir = $rootDir;
        $this->framework = $framework;

        parent::__construct();
    }

    protected function configure(): void
    {
        $this
            ->setName('dmkzwo:additions')
            ->setDescription("all files found in contao/additions are added to the system");

        $this->addOption(
            'force',
            null,
            InputOption::VALUE_NONE,
            "disables confirmation"
        );
    }

    protected function execute(InputInterface $input, OutputInterface $output): int
    {
        $this->framework->initialize();

        $output->writeln([
            '',
            "Adds files to the system",
            '',
            "All files found in contao/additions are added to the system. Remember to add them with their full target path.",
            '',
            "'--force' disables user confirmation (for script use)",
            '',
        ]);

        $force = !empty($input->getOption('force'));

        if (!$force) {
            $helper = $this->getHelper('question');
            $question = new ConfirmationQuestion('Press any key to continue or ^C to cancel...', true);

            if (!$helper->ask($input, $output, $question)) {
                return 0;
            }
        }
        $output->writeln('');

//        $this->createTemplate = !empty($input->getOption('create-template'));
//
//        if ($this->createTemplate) {
//            $srcFile = $this->rootDir.'/system/config/localconfig.php';
//            $targetFile = $this->rootDir.'/system/config/__localconfig.php';
//        } else {
//            $srcFile = $this->rootDir.'/system/config/__localconfig.php';
//            $targetFile = $this->rootDir.'/system/config/localconfig.php';
//        }

        $additionsDir = $this->rootDir . '/contao/additions/';

        if (!file_exists($additionsDir) || !is_dir($additionsDir)) {
            $output->writeln([
                '',
                '------------------',
                'No directory contao/additions found.',
                'Nothing to do.',
                '',
            ]);

            return 0;
        }

        $additionalFiles = [];
        $additionalDirs = [];

        $iterator = new \RecursiveIteratorIterator(new \RecursiveDirectoryIterator($additionsDir));
        foreach ($iterator as $file) {
            if (strpos($file->getPathname(), '..') !== false) {
                continue;
            }

            $path = $file->getPathname();
            $relativePath = str_replace($additionsDir, '', $path);

            if ($file->isDir()) {
                $additionalDirs[] = $relativePath;
            } else {
                $additionalFiles[] = $relativePath;
            }
        }

        if (!sizeof($additionalFiles)) {
            $output->writeln([
                '',
                '------------------',
                'No files found in contao/additions.',
                'Nothing to do!',
                '',
            ]);

            return 0;
        }

        foreach ($additionalDirs as $additionalDir) {
            $targetDir = $this->rootDir . '/' . $additionalDir;

            if (!file_exists($targetDir) || !is_dir($targetDir)) {
                mkdir($targetDir, 0777, true);
            }

            $output->writeln([
                'MKDIR: ' . $targetDir,
            ]);

        }

        foreach ($additionalFiles as $additionalFile) {
            $targetFile = $this->rootDir . '/' . $additionalFile;
            $srcFile = $this->rootDir . '/contao/additions/' . $additionalFile;

            $fs = new Filesystem();
            $fs->copy($srcFile, $targetFile);

            $output->writeln([
                'COPY: ' . $additionalFile . ' -> ' . $targetFile,
            ]);

        }

//        if (!file_exists($srcFile)) {
//            throw new \RuntimeException(sprintf('File %s missing', $srcFile));
//        }
//
//        $fs = new Filesystem();
//        $fs->copy($srcFile, $targetFile);
//
//        $output->writeln([
//            '',
//            '------------------',
//            sprintf('%s created', $targetFile),
//            '',
//        ]);

        // $output->writeln(file_get_contents($parametersFile));

        return 0;
    }
}
