<?php

declare(strict_types=1);

/*
 * This file is part of [dmkzwo/contao-hello-world-bundle].
 *
 * (c) Dmkzwo
 *
 * @license LGPL-3.0-or-later
 */

namespace Dmkzwo\ContaoDzConextBundle\Classes\Command;

use Contao\CoreBundle\Framework\ContaoFramework;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Console\Question\ConfirmationQuestion;
use Symfony\Component\Filesystem\Filesystem;

class FixesCommand extends DbBaseCommand
{
    private $rootDir;
    private $framework;

//    private $createTemplate;

    public function __construct(string $rootDir, ContaoFramework $framework)
    {
        $this->rootDir = $rootDir;
        $this->framework = $framework;

        parent::__construct();
    }

    protected function configure(): void
    {
        $this
            ->setName('dmkzwo:fixes')
            ->setDescription("Applies non update safe changes to the system (aka hacks); all files found in contao/fixes are added to the system");

//        $this->addOption(
//            'create-template',
//            null,
//            InputOption::VALUE_NONE,
//            "creates 'system/config/__localconfig.php' from 'system/config/localconfig.php'"
//        );
    }

    protected function execute(InputInterface $input, OutputInterface $output): int
    {
        $this->framework->initialize();

        $output->writeln([
            '',
            "Applies non update safe changes to the system (aka hacks)",
            '',
            "All files found in contao/fixes are added to the system. Remember to add them with their full target path.",
            '',
        ]);

        $helper = $this->getHelper('question');
        $question = new ConfirmationQuestion('Press any key to continue or ^C to cancel...', true);

        if (!$helper->ask($input, $output, $question)) {
            return 0;
        }

        $output->writeln('');

//        $this->createTemplate = !empty($input->getOption('create-template'));
//
//        if ($this->createTemplate) {
//            $srcFile = $this->rootDir.'/system/config/localconfig.php';
//            $targetFile = $this->rootDir.'/system/config/__localconfig.php';
//        } else {
//            $srcFile = $this->rootDir.'/system/config/__localconfig.php';
//            $targetFile = $this->rootDir.'/system/config/localconfig.php';
//        }

        $fixesDir = $this->rootDir.'/contao/fixes/';

        if (!file_exists($fixesDir) || !is_dir($fixesDir)) {
            $output->writeln([
                '',
                '------------------',
                'No directory contao/fixes found.',
                'Nothing to do.',
                '',
            ]);

            return 0;
        }

        $fixesFiles = [];

        $iterator = new \RecursiveIteratorIterator(new \RecursiveDirectoryIterator($fixesDir));
        foreach ($iterator as $file) {
            if ($file->isDir()) continue;
            $path = $file->getPathname();
            $relativePath = str_replace($fixesDir, '', $path);

            $fixesFiles[] = $relativePath;
        }

        if (!sizeof($fixesFiles)) {
            $output->writeln([
                '',
                '------------------',
                'No files found in contao/fixes.',
                'Nothing to do!',
                '',
            ]);

            return 0;
        }

        foreach ($fixesFiles as $fixesFile) {
            $targetFile = $this->rootDir . '/' . $fixesFile;

            if (!file_exists($targetFile) || !is_file($targetFile)) {
                $output->writeln([
                    'COPY: ' . $fixesFile . ' -> [TARGETFILE DOES NOT EXIST / SKIPPED]',
                ]);

            } else {
                $output->writeln([
                    'COPY: ' . $fixesFile . ' -> ' . $targetFile,
                ]);

            }

        }

//        if (!file_exists($srcFile)) {
//            throw new \RuntimeException(sprintf('File %s missing', $srcFile));
//        }
//
//        $fs = new Filesystem();
//        $fs->copy($srcFile, $targetFile);
//
//        $output->writeln([
//            '',
//            '------------------',
//            sprintf('%s created', $targetFile),
//            '',
//        ]);

        // $output->writeln(file_get_contents($parametersFile));

        return 0;
    }
}
