<?php

declare(strict_types=1);

/*
 * This file is part of [dmkzwo/contao-hello-world-bundle].
 *
 * (c) Dmkzwo
 *
 * @license LGPL-3.0-or-later
 */

namespace Dmkzwo\ContaoDzConextBundle\Classes\Command;

use Contao\CoreBundle\Framework\ContaoFramework;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Console\Question\ConfirmationQuestion;
use Symfony\Component\Filesystem\Filesystem;

class LocalconfigCommand extends DbBaseCommand
{
    private $rootDir;
    private $framework;

    private $createTemplate;

    public function __construct(string $rootDir, ContaoFramework $framework)
    {
        $this->rootDir = $rootDir;
        $this->framework = $framework;

        parent::__construct();
    }

    protected function configure(): void
    {
        $this
            ->setName('dmkzwo:localconfig')
            ->setDescription("Creates 'system/config/localconfig.php' from 'system/config/__localconfig.php' or vice versa");

        $this->addOption(
            'create-template',
            null,
            InputOption::VALUE_NONE,
            "creates 'system/config/__localconfig.php' from 'system/config/localconfig.php'"
        );
    }

    protected function execute(InputInterface $input, OutputInterface $output): int
    {
        $this->framework->initialize();

        $output->writeln([
            '',
            "This creates/overrides 'system/config/localconfig.php' from 'system/config/__localconfig.php'.",
            '',
            "'--create-template' works the other way round.",
            '',
        ]);

        $helper = $this->getHelper('question');
        $question = new ConfirmationQuestion('Press any key to continue or ^C to cancel...', true);

        if (!$helper->ask($input, $output, $question)) {
            return 0;
        }

        $this->createTemplate = !empty($input->getOption('create-template'));

        if ($this->createTemplate) {
            $srcFile = $this->rootDir.'/system/config/localconfig.php';
            $targetFile = $this->rootDir.'/system/config/__localconfig.php';
        } else {
            $srcFile = $this->rootDir.'/system/config/__localconfig.php';
            $targetFile = $this->rootDir.'/system/config/localconfig.php';
        }

        if (!file_exists($srcFile)) {
            throw new \RuntimeException(sprintf('File %s missing', $srcFile));
        }

        $fs = new Filesystem();
        $fs->copy($srcFile, $targetFile);

        $output->writeln([
            '',
            '------------------',
            sprintf('%s created', $targetFile),
            '',
        ]);

        // $output->writeln(file_get_contents($parametersFile));

        return 0;
    }
}
