<?php

/*
 * This file is part of [dmkzwo/contao-hello-world-bundle].
 *
 * (c) Dmkzwo
 *
 * @license LGPL-3.0-or-later
 */

namespace Dmkzwo\ContaoDzConextBundle\Classes\Command;

use Contao\CoreBundle\Framework\FrameworkAwareInterface;
use Contao\CoreBundle\Framework\FrameworkAwareTrait;
use Contao\CoreBundle\Util\PackageUtil;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Console\Question\ConfirmationQuestion;
use Symfony\Component\Console\Question\Question;

class ExampleCommand extends Command // implements FrameworkAwareInterface
{
    // use FrameworkAwareTrait;

    private $framework;

    private $connection;

    private $arg1;

    public function __construct($framework, $connection, $arg1)
    {
        $this->framework = $framework;
        $this->connection = $connection;
        $this->arg1 = $arg1;

        parent::__construct();
    }

    protected function configure()
    {
        $this
            ->setName('dmkzwo:example')
            ->setDescription('Outputs test output')
        ;

        // arguments are ordered!
        $this->addArgument('arg2', InputArgument::REQUIRED, 'Argument 2');
        $this->addArgument('arg3', InputArgument::OPTIONAL, 'Argument 3');

        // options are not ordered!
        $this->addOption(
            'option1',
            'o',
            InputOption::VALUE_REQUIRED,
            'Value for option 1',
            'default value'
        );

//        $this->addOption(
//            'optionname',  // use with --optionname=...
//            'o',           // single char (OR NULL), use -with -o ...
//            InputOption::VALUE_REQUIRED,  // or VALUE_OPTIONAL, VALUE_NONE (boolean), VALUE_IS_ARRAY (can be combined)
//            'label',       // Explanation for this option
//            'default'      // Default value, used when the option is missing
//        );
    }

    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $this->framework->initialize();

        $helper = $this->getHelper('question');
        $question = new ConfirmationQuestion('Press any key to continue or ^C to cancel...', true);

        if (!$helper->ask($input, $output, $question)) {
            return;
        }

        $questionDbName = new Question('Database name: ');
//        $questionDbName->setNormalizer(function ($value) {
//            // $value can be null here
//            return $value ? trim($value) : '';
//        });
        $questionDbName->setValidator(function ($answer) {
            if (!\is_string($answer) || !preg_match('/^[a-zA-Z0-9_]+$/', $answer)) {
                throw new \RuntimeException('Invalid or empty database name');
            }

            return $answer;
        });

        $databaseName = $helper->ask($input, $output, $questionDbName);

        $output->writeln('db name: #'.$databaseName.'#');

//        $output->writeln(PackageUtil::getContaoVersion());
        $output->writeln($this->arg1);

        $output->writeln('arg2: '.$input->getArgument('arg2'));

        if (!empty($input->getArgument('arg3'))) {
            $output->writeln('arg3: '.$input->getArgument('arg3'));
        }

        if (!empty($input->getOption('option1'))) {
            $output->writeln('option1: '.$input->getOption('option1'));
        }

        return 0;
    }
}

//use Contao\CoreBundle\Command\AbstractLockedCommand;
////use Esit\Xmlcatchregion\Classes\Events\Import\OnImportEvent;
//use Symfony\Component\Console\Input\InputArgument;
//use Symfony\Component\Console\Input\InputInterface;
//use Symfony\Component\Console\Output\OutputInterface;
//use Symfony\Component\Console\Style\SymfonyStyle;
//use Symfony\Component\EventDispatcher\EventDispatcherInterface;
//
//
//class DemoOutputCommand extends AbstractLockedCommand
//{
//
//    // use FrameworkAwareTrait;
//
//    private $io;
//
//    private $rows = [];
//
//    private $statusCode = 0;
//
//
//    protected function configure() {
//        $commandHelp    = 'Erzeugt eine Testausgabe';
//        $parameterHelp  = 'Name, der in der Testausgabe verwendet werden soll';
//        $argument       = new InputArgument('name', InputArgument::REQUIRED, $parameterHelp);
//        // Hier könnten weitere Parameter folgen.
//
//        $this->setName('demo:testoutput')
//            ->setDefinition([$argument])   // Die Parameter werden als Array übergeben, so kann es mehr als ein geben.
//            ->setDescription($commandHelp);
//    }
//
//
//    protected function executeLocked(InputInterface $input, OutputInterface $output) {
//
//        // Framework initialisieren
//        $this->framework->initialize();
//
//        $this->io = new SymfonyStyle($input, $output);
//
//        /* Wird hier nicht benötigt, ist aber ganz nützlich.
//
//        // Der Container steht im Konstruktor noch nicht zur Verfügung und kann somit nicht injiziert werden!
//        $this->di = $this->getContainer()->get('event_dispatcher');
//
//        // TL_ROOT kann nicht injiziert werden und steht im Command nicht zur Verfügung!
//        // Deshalb wird hier das root directory ausgelesen.
//        $rootDir = $this->getContainer()->getParameter('kernel.project_dir');
//
//        */
//
//        // Hier wird der Kommandozeilenparameter ausgelesen.
//        $name = $input->getArgument('name');
//
//        // Hier wird die eigentliche Verarbeitung auf gerufen.
//        $this->demoOutput($name);
//
//        if (!empty($this->rows)) {
//            $this->io->newLine();
//            $this->io->table(['', 'Ouput', 'Target / Error'], $this->rows);
//        }
//
//        return $this->statusCode;
//    }
//
//
//    protected function demoOutput($name): void
//    {
//        // Hier findet die eigentliche Verarbeitung statt.
//        // Normalerweise würde hier z.B. ein Event aufgerufen.
//        $this->io->text("Hallo $name!");
//    }
//}
