<?php

declare(strict_types=1);

/*
 * This file is part of [dmkzwo/contao-hello-world-bundle].
 *
 * (c) Dmkzwo
 *
 * @license LGPL-3.0-or-later
 */

namespace Dmkzwo\ContaoDzConextBundle\Classes\Command;

use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Console\Question\Question;

abstract class DbBaseCommand extends Command
{
    protected $databaseName;
    protected $databaseUser;
    protected $databasePassword;
    protected $databaseHost;
    protected $databasePort;

    protected function addDbParamQuestions(InputInterface $input, OutputInterface $output): void
    {
        /* Ask for database name */
        $questionDbName = new Question('Enter the database name: ');
        $questionDbName->setValidator(function ($answer) {
            if (!\is_string($answer) || !preg_match('/^[a-zA-Z0-9_]+$/', $answer)) {
                throw new \RuntimeException('Invalid or empty database name');
            }

            return $answer;
        });

        /* Ask for database user */
        $questionDbUser = new Question('Enter the database user: ');
        $questionDbUser->setValidator(function ($answer) {
            if (!\is_string($answer)) {
                throw new \RuntimeException('Empty database user');
            }

            return $answer;
        });

        /* Ask for database password */
        $questionDbPassword = new Question('Enter the database password: ');
        $questionDbPassword->setValidator(function ($answer) {
            if (!\is_string($answer)) {
                throw new \RuntimeException('Empty database password');
            }

            return $answer;
        });

        /* Ask for database host */
        $questionDbHost = new Question('Enter the database host [localhost]: ', 'localhost');
        $questionDbHost->setValidator(function ($answer) {
            if (!\is_string($answer)) {
                throw new \RuntimeException('Empty database host');
            }

            return $answer;
        });

        /* Ask for database port */
        $questionDbPort = new Question('Enter the database port [3306]: ', '3306');
        $questionDbPort->setValidator(function ($answer) {
            if (!\is_string($answer)) {
                throw new \RuntimeException('Empty database port');
            }

            return $answer;
        });

        $helper = $this->getHelper('question');

        $this->databaseHost = $helper->ask($input, $output, $questionDbHost);
        $this->databasePort = $helper->ask($input, $output, $questionDbPort);
        $this->databaseName = $helper->ask($input, $output, $questionDbName);
        $this->databaseUser = $helper->ask($input, $output, $questionDbUser);
        $this->databasePassword = $helper->ask($input, $output, $questionDbPassword);
    }

    protected function replaceDbPlaceholders(string $content): string
    {
        return str_replace(
            [
                '<database_user>',
                '<database_password>',
                '<database_name>',
                '<database_host>',
                '<database_port>',
            ],
            [
                $this->databaseUser,
                $this->databasePassword,
                $this->databaseName,
                $this->databaseHost,
                $this->databasePort,
            ],
            $content);
    }
}
