var docs = (function () {

    var init = function () {
        $('.js-docscluster-doc-toggle').attr('tabindex', '-1');
        addEventListeners();
        return;
    };

    var addEventListeners = function () {

        $('.js-docscluster-toggle').on('click keydown', handleDocsclusterToggle);
        $('.js-docscluster-doc-toggle').on('click keydown', handleDocsclusterDocToggle);

    }

    var handleDocsclusterToggle = function (event) {
        if ((event.type === 'keydown') && (event.keyCode !== 13) && (event.keyCode !== 32)) {
            return;
        }

        var currentTarget = event.currentTarget;

        var parent = $(currentTarget).parents('.ce_dzdocscluster');
        var isExpanded = ($(currentTarget).attr('aria-expanded') === 'true');

        parent.toggleClass('ce_dzdocscluster--open');

        // parent.find('.ce_dzdocscluster__headline').toggleClass('.ce_dzdocscluster__headline--open');
        parent.find('.ce_dzdocscluster__content').slideToggle();

        // $(currentTarget).attr('aria-expanded', ($(currentTarget).attr('aria-expanded') === 'false') ? 'true' : 'false');

        if (!isExpanded) {
            $(currentTarget).attr('aria-expanded', 'true');
            parent.find('.js-docscluster-doc-toggle').attr('tabindex', '0')
        } else {
            $(currentTarget).attr('aria-expanded', 'false');
            parent.find('.js-docscluster-doc-toggle').attr('tabindex', '-1')
        }
    }

    var handleDocsclusterDocToggle = function (event) {
        if ((event.type === 'keydown') && (event.keyCode !== 13) && (event.keyCode !== 32)) {
            return;
        }

        var currentTarget = event.currentTarget;

        var parent = $(currentTarget).parents('.ce_dzdocscluster__doc');

        parent.toggleClass('ce_dzdocscluster__doc--open');

        parent.find('.ce_dzdocscluster__doc-content').slideToggle();

        $(this).attr('aria-expanded', ($(this).attr('aria-expanded') === 'false') ? 'true' : 'false');
    }

    return {
        init: init
    }

})();

docs.init();

