<?php

/*
 * This file is part of [dmkzwo/contao-docs-bundle].
 *
 * (c) Dmkzwo
 *
 * @license LGPL-3.0-or-later
 */

namespace Dmkzwo\ContaoDocsBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;

class DevController extends Controller
{
    /**
     * @Route("/docs/dev/prepare", name="docs_dev_prepare", defaults={"_scope" = "frontend", "_token_check" = false})
     */
    public function prepareAction()
    {
        $this->container->get('contao.framework')->initialize();

        $coverDir = $this->container->getParameter('ww.docs_cover_default_dir');
        $teaserDir = $this->container->getParameter('ww.docs_teaser_default_dir');

        if (!is_dir(TL_ROOT.'/'.$coverDir)) {
            mkdir(TL_ROOT.'/'.$coverDir, 0755, true);
        }
        if (!is_dir(TL_ROOT.'/'.$teaserDir)) {
            mkdir(TL_ROOT.'/'.$teaserDir, 0755, true);
        }

        return new Response();
    }
}
