var docs = (function () {

    var init = function () {
        addEventListeners();
        return;
    };

    var addEventListeners = function () {

        $('.js-docscluster-toggle').on('click', handleDocsclusterToggle);
        $('.js-docscluster-doc-toggle').on('click', handleDocsclusterDocToggle);

    }

    var handleDocsclusterToggle = function (event) {
        var currentTarget = event.currentTarget;

        var parent = $(currentTarget).parents('.ce_dzdocscluster');

        parent.toggleClass('ce_dzdocscluster--open');

        // parent.find('.ce_dzdocscluster__headline').toggleClass('.ce_dzdocscluster__headline--open');
        parent.find('.ce_dzdocscluster__content').slideToggle();

        $(currentTarget).attr('aria-expanded', ($(currentTarget).attr('aria-expanded') === 'false') ? 'true' : 'false');
    }

    var handleDocsclusterDocToggle = function (event) {
        var currentTarget = event.currentTarget;

        var parent = $(currentTarget).parents('.ce_dzdocscluster__doc');

        parent.toggleClass('ce_dzdocscluster__doc--open');

        parent.find('.ce_dzdocscluster__doc-content').slideToggle();

        $(this).attr('aria-expanded', ($(this).attr('aria-expanded') === 'false') ? 'true' : 'false');
    }

    return {
        init: init
    }

})();

docs.init();

