<?php


\System::loadLanguageFile('tl_content');

$GLOBALS['TL_DCA']['tl_docs'] = array
(
	// Config
	'config' => array
	(
		'dataContainer'               => 'Table',
		'ptable'                      => 'tl_docs_category',
		'enableVersioning'            => true,
		'markAsCopy'                  => 'title',
		'onload_callback' => array
		(
			array('tl_docs', 'checkPermission')
		),
		'sql' => array
		(
			'keys' => array
			(
				'id' => 'primary',
				'pid,published,sorting' => 'index'
			)
		)
	),

	// List
	'list' => array
	(
		'sorting' => array
		(
			'mode'                    => 4,
			'fields'                  => array('sorting'),
			'panelLayout'             => 'filter;sort,search,limit',
			'headerFields'            => array('title', 'jumpTo'),
			'child_record_callback'   => array('tl_docs', 'listTitles')
		),
		'global_operations' => array
		(
			'all' => array
			(
				'href'                => 'act=select',
				'class'               => 'header_edit_all',
				'attributes'          => 'onclick="Backend.getScrollOffset()" accesskey="e"'
			)
		),
		'operations' => array
		(
			'edit' => array
			(
				'href'                => 'act=edit',
				'icon'                => 'edit.svg'
			),
			'copy' => array
			(
				'href'                => 'act=paste&amp;mode=copy',
				'icon'                => 'copy.svg'
			),
			'cut' => array
			(
				'href'                => 'act=paste&amp;mode=cut',
				'icon'                => 'cut.svg'
			),
			'delete' => array
			(
				'href'                => 'act=delete',
				'icon'                => 'delete.svg',
				'attributes'          => 'onclick="if(!confirm(\'' . $GLOBALS['TL_LANG']['MSC']['deleteConfirm'] . '\'))return false;Backend.getScrollOffset()"'
			),
			'toggle' => array
			(
				'icon'                => 'visible.svg',
				'attributes'          => 'onclick="Backend.getScrollOffset();return AjaxRequest.toggleVisibility(this,%s)"',
				'button_callback'     => array('tl_docs', 'toggleIcon')
			),
			'show' => array
			(
				'href'                => 'act=show',
				'icon'                => 'show.svg'
			)
		)
	),

	// Palettes
	'palettes' => array
	(
		'__selector__'                => array('addCover', 'addTeaserImage'),
//		'default'                     => '{title_legend},title,alias;{answer_legend},answer;{image_legend},addImage;{enclosure_legend:hide},addEnclosure;{expert_legend:hide},noComments;{publish_legend},published',
		'default'                     => 'title,alias,published,language,docType,publisher,releaseDate,version,hideReleaseDate,fileSRC,infoText;{image_legend},addCover,addTeaserImage;{links_legend},links'
	),

	// Subpalettes
	'subpalettes' => array
	(
		'addCover'                    => 'coverSRC',
        'addTeaserImage'              => 'teaserImageSRC,teaserImageSize',
		'addEnclosure'                => 'enclosure',
		'overwriteMeta'               => 'alt,imageTitle,imageUrl,caption'
	),

	// Fields
	'fields' => array
	(
		'id' => array
		(
			'sql'                     => "int(10) unsigned NOT NULL auto_increment"
		),
		'pid' => array
		(
			'foreignKey'              => 'tl_docs_category.title',
			'sql'                     => "int(10) unsigned NOT NULL default 0",
			'relation'                => array('type'=>'belongsTo', 'load'=>'lazy')
		),
		'sorting' => array
		(
			'label'                   => &$GLOBALS['TL_LANG']['MSC']['sorting'],
			'sorting'                 => true,
			'flag'                    => 11,
			'sql'                     => "int(10) unsigned NOT NULL default 0"
		),
		'tstamp' => array
		(
			'sql'                     => "int(10) unsigned NOT NULL default 0"
		),
		'title' => array
		(
			'exclude'                 => true,
			'search'                  => true,
			'sorting'                 => true,
			'flag'                    => 1,
			'inputType'               => 'text',
			'eval'                    => array('mandatory'=>true, 'maxlength'=>255, 'tl_class'=>'long'),
			'sql'                     => "varchar(255) NOT NULL default ''"
		),
		'alias' => array
		(
			'exclude'                 => true,
			'search'                  => true,
			'inputType'               => 'text',
			'eval'                    => array('rgxp'=>'alias', 'doNotCopy'=>true, 'unique'=>true, 'maxlength'=>128, 'tl_class'=>'w50'),
			'save_callback' => array
			(
				array('tl_docs', 'generateAlias')
			),
			'sql'                     => "varchar(255) BINARY NOT NULL default ''"
		),
        'published' => array
        (
            'exclude'                 => true,
            'filter'                  => true,
            'flag'                    => 2,
            'inputType'               => 'checkbox',
            'eval'                    => array('doNotCopy'=>true, 'tl_class' => 'w50'),
            'sql'                     => "char(1) NOT NULL default ''"
        ),

        'language' => array
        (
            'exclude'                 => true,
            'search'                  => true,
            'sorting'                 => true,
            'flag'                    => 1,
            'inputType'               => 'radio',
            'options_callback'        => array('\Dmkzwo\ContaoDocsBundle\Classes\DocsDca', 'getLanguageBackendOptions'),
            'default'                 => 'de',
            'eval'                    => array('mandatory'=>true, 'maxlength'=>255, 'tl_class'=>'clr w50'),
            'sql'                     => "char(16) NOT NULL default 'de'"
        ),
        'docType' => array
        (
            'exclude'                 => true,
            'search'                  => true,
            'sorting'                 => true,
            'flag'                    => 1,
            'inputType'               => 'radio',
            'options_callback'        => array('\\Dmkzwo\\ContaoDocsBundle\\Classes\\DocsDca', 'getDoctypeBackendOptions'),
            'default'                 => 'form',
            'eval'                    => array('mandatory'=>true, 'maxlength'=>255, 'tl_class'=>'w50'),
            'sql'                     => "char(16) NOT NULL default 'form'"
        ),
        'publisher' => array
        (
            'exclude'                 => true,
            'search'                  => true,
            'sorting'                 => true,
            'flag'                    => 1,
            'inputType'               => 'text',
            'eval'                    => array('mandatory'=>false, 'maxlength'=>255, 'tl_class'=>'clr long'),
            'sql'                     => "varchar(255) NOT NULL default ''"
        ),
        'version' => array
        (
            'exclude'                 => true,
            'search'                  => true,
            'sorting'                 => true,
            'flag'                    => 1,
            'inputType'               => 'text',
            'eval'                    => array('mandatory'=>false, 'maxlength'=>255, 'tl_class'=>'w50'),
            'sql'                     => "varchar(255) NOT NULL default ''"
        ),
        'releaseDate' => array
        (
            'default'                 => time(),
            'exclude'                 => true,
            'filter'                  => true,
            'sorting'                 => true,
            'flag'                    => 8,
            'inputType'               => 'text',
            'eval'                    => array('rgxp'=>'date', 'mandatory'=>false, 'datepicker'=>true, 'tl_class'=>'clr w50 wizard'),
//            'load_callback' => array
//            (
//                array('tl_news', 'loadDate')
//            ),
            'sql'                     => "int(10) unsigned NOT NULL default 0"
        ),
        'hideReleaseDate' => array
        (
            'exclude'                 => true,
            'filter'                  => true,
            'inputType'               => 'checkbox',
            'eval'                    => array('tl_class'=>'clr long'),
            'sql'                     => "char(1) NOT NULL default ''"
        ),
		'fileSRC' => array
		(
			'exclude'                 => true,
			'inputType'               => 'fileTree',
			'eval'                    => array('mandatory' => true, 'fieldType'=>'radio', 'filesOnly'=>true, 'isDownloads'=>true, 'extensions'=>\Config::get('allowedDownload'), 'tl_class' => 'clr'),
			'sql'                     => "binary(16) NULL"
		),
        'infoText' => array
        (
            'exclude'                 => true,
            'inputType'               => 'textarea',
            'eval'                    => array('mandatory'=>false, 'tl_class'=>'clr long', 'rte'=>'tinyMCE', 'helpwizard'=>true),
            'sql'                     => "text NULL"
        ),
		'addCover' => array
		(
			'exclude'                 => true,
			'filter'                  => true,
			'inputType'               => 'checkbox',
			'eval'                    => array('submitOnChange'=>true),
			'sql'                     => "char(1) NOT NULL default ''"
		),
		'coverSRC' => array
		(
			'exclude'                 => true,
			'inputType'               => 'fileTree',
			'eval'                    => array('fieldType'=>'radio', 'filesOnly'=>true, 'extensions'=>\Config::get('validImageTypes'), 'mandatory'=>false),
			'sql'                     => "binary(16) NULL"
		),
        'addTeaserImage' => array
        (
            'exclude'                 => true,
            'filter'                  => true,
            'inputType'               => 'checkbox',
            'eval'                    => array('submitOnChange'=>true),
            'sql'                     => "char(1) NOT NULL default ''"
        ),
        'teaserImageSRC' => array
        (
            'exclude'                 => true,
            'inputType'               => 'fileTree',
            'eval'                    => array('fieldType'=>'radio', 'filesOnly'=>true, 'extensions'=>\Config::get('validImageTypes'), 'mandatory'=>false),
            'sql'                     => "binary(16) NULL"
        ),
        'teaserImageSize' => array
        (
            'exclude'                 => true,
            'inputType'               => 'imageSize',
            'reference'               => &$GLOBALS['TL_LANG']['MSC'],
            'eval'                    => array('rgxp'=>'natural', 'includeBlankOption'=>true, 'nospace'=>true, 'helpwizard'=>true, 'tl_class'=>'w50'),
            'options_callback' => static function ()
            {
                return Contao\System::getContainer()->get('contao.image.image_sizes')->getOptionsForUser(Contao\BackendUser::getInstance());
            },
            'sql'                     => "varchar(255) NOT NULL default ''"
        ),

        'links' => array(
            'exclude'                 => true,
            'inputType'               => 'multiColumnWizard',
            'eval' 			=> array
            (
                'buttonPos' => 'top',
                //'minCount' => 0,
                //'maxCount' => 3,
                'tl_class' => 'clr long',
                'mandatory' => false,
                'columnFields' => array
                (
                    'doc_id' => array
                    (
                        'label'                   => &$GLOBALS['TL_LANG']['tl_docs']['doc_id'],
                        'inputType'               => 'select',
                        'options_callback'        => array('\\Dmkzwo\\ContaoDocsBundle\\Classes\\DocsDca', 'getDocsBackendOptions'),
                        'eval'                    => array('mandatory' => false, 'style' => 'width:500px'),
                    ),
                )
            ),
            'sql'                     => "blob NULL",

        ),

//		'author' => array
//		(
//			'default'                 => \BackendUser::getInstance()->id,
//			'exclude'                 => true,
//			'search'                  => true,
//			'filter'                  => true,
//			'sorting'                 => true,
//			'flag'                    => 11,
//			'inputType'               => 'select',
//			'foreignKey'              => 'tl_user.name',
//			'eval'                    => array('doNotCopy'=>true, 'chosen'=>true, 'mandatory'=>true, 'includeBlankOption'=>true, 'tl_class'=>'w50'),
//			'sql'                     => "int(10) unsigned NOT NULL default 0",
//			'relation'                => array('type'=>'belongsTo', 'load'=>'lazy')
//		),
//		'answer' => array
//		(
//			'exclude'                 => true,
//			'search'                  => true,
//			'inputType'               => 'textarea',
//			'eval'                    => array('mandatory'=>true, 'rte'=>'tinyMCE', 'helpwizard'=>true),
//			'explanation'             => 'insertTags',
//			'sql'                     => "text NULL"
//		),
//		'addImage' => array
//		(
//			'exclude'                 => true,
//			'filter'                  => true,
//			'inputType'               => 'checkbox',
//			'eval'                    => array('submitOnChange'=>true),
//			'sql'                     => "char(1) NOT NULL default ''"
//		),
//		'overwriteMeta' => array
//		(
//			'label'                   => &$GLOBALS['TL_LANG']['tl_content']['overwriteMeta'],
//			'exclude'                 => true,
//			'inputType'               => 'checkbox',
//			'eval'                    => array('submitOnChange'=>true, 'tl_class'=>'w50 clr'),
//			'sql'                     => "char(1) NOT NULL default ''"
//		),
//		'singleSRC' => array
//		(
//			'label'                   => &$GLOBALS['TL_LANG']['tl_content']['singleSRC'],
//			'exclude'                 => true,
//			'inputType'               => 'fileTree',
//			'eval'                    => array('fieldType'=>'radio', 'filesOnly'=>true, 'extensions'=>\Config::get('validImageTypes'), 'mandatory'=>true),
//			'sql'                     => "binary(16) NULL"
//		),
//		'alt' => array
//		(
//			'label'                   => &$GLOBALS['TL_LANG']['tl_content']['alt'],
//			'exclude'                 => true,
//			'search'                  => true,
//			'inputType'               => 'text',
//			'eval'                    => array('maxlength'=>255, 'tl_class'=>'w50'),
//			'sql'                     => "varchar(255) NOT NULL default ''"
//		),
//		'imageTitle' => array
//		(
//			'label'                   => &$GLOBALS['TL_LANG']['tl_content']['imageTitle'],
//			'exclude'                 => true,
//			'search'                  => true,
//			'inputType'               => 'text',
//			'eval'                    => array('maxlength'=>255, 'tl_class'=>'w50'),
//			'sql'                     => "varchar(255) NOT NULL default ''"
//		),
//		'size' => array
//		(
//			'label'                   => &$GLOBALS['TL_LANG']['tl_content']['size'],
//			'exclude'                 => true,
//			'inputType'               => 'imageSize',
//			'reference'               => &$GLOBALS['TL_LANG']['MSC'],
//			'eval'                    => array('rgxp'=>'natural', 'includeBlankOption'=>true, 'nospace'=>true, 'helpwizard'=>true, 'tl_class'=>'w50'),
//			'options_callback' => static function ()
//			{
//				return \System::getContainer()->get('contao.image.image_sizes')->getOptionsForUser(\BackendUser::getInstance());
//			},
//			'sql'                     => "varchar(64) NOT NULL default ''"
//		),
//		'imagemargin' => array
//		(
//			'label'                   => &$GLOBALS['TL_LANG']['tl_content']['imagemargin'],
//			'exclude'                 => true,
//			'inputType'               => 'trbl',
//			'options'                 => $GLOBALS['TL_CSS_UNITS'],
//			'eval'                    => array('includeBlankOption'=>true, 'tl_class'=>'w50'),
//			'sql'                     => "varchar(128) NOT NULL default ''"
//		),
//		'imageUrl' => array
//		(
//			'label'                   => &$GLOBALS['TL_LANG']['tl_content']['imageUrl'],
//			'exclude'                 => true,
//			'search'                  => true,
//			'inputType'               => 'text',
//			'eval'                    => array('rgxp'=>'url', 'decodeEntities'=>true, 'maxlength'=>255, 'dcaPicker'=>true, 'addWizardClass'=>false, 'tl_class'=>'w50'),
//			'sql'                     => "varchar(255) NOT NULL default ''"
//		),
//		'fullsize' => array
//		(
//			'label'                   => &$GLOBALS['TL_LANG']['tl_content']['fullsize'],
//			'exclude'                 => true,
//			'inputType'               => 'checkbox',
//			'eval'                    => array('tl_class'=>'w50 m12'),
//			'sql'                     => "char(1) NOT NULL default ''"
//		),
//		'caption' => array
//		(
//			'label'                   => &$GLOBALS['TL_LANG']['tl_content']['caption'],
//			'exclude'                 => true,
//			'search'                  => true,
//			'inputType'               => 'text',
//			'eval'                    => array('maxlength'=>255, 'allowHtml'=>true, 'tl_class'=>'w50'),
//			'sql'                     => "varchar(255) NOT NULL default ''"
//		),
//		'floating' => array
//		(
//			'label'                   => &$GLOBALS['TL_LANG']['tl_content']['floating'],
//			'exclude'                 => true,
//			'inputType'               => 'radioTable',
//			'options'                 => array('above', 'left', 'right', 'below'),
//			'eval'                    => array('cols'=>4, 'tl_class'=>'w50'),
//			'reference'               => &$GLOBALS['TL_LANG']['MSC'],
//			'sql'                     => "varchar(12) NOT NULL default 'above'"
//		),
//		'addEnclosure' => array
//		(
//			'exclude'                 => true,
//			'filter'                  => true,
//			'inputType'               => 'checkbox',
//			'eval'                    => array('submitOnChange'=>true),
//			'sql'                     => "char(1) NOT NULL default ''"
//		),
//		'enclosure' => array
//		(
//			'exclude'                 => true,
//			'inputType'               => 'fileTree',
//			'eval'                    => array('multiple'=>true, 'fieldType'=>'checkbox', 'filesOnly'=>true, 'isDownloads'=>true, 'extensions'=>\Config::get('allowedDownload'), 'mandatory'=>true, 'orderField'=>'orderEnclosure'),
//			'sql'                     => "blob NULL"
//		),
//		'orderEnclosure' => array
//		(
//			'label'                   => &$GLOBALS['TL_LANG']['MSC']['sortOrder'],
//			'sql'                     => "blob NULL"
//		),
//		'noComments' => array
//		(
//			'exclude'                 => true,
//			'filter'                  => true,
//			'inputType'               => 'checkbox',
//			'sql'                     => "char(1) NOT NULL default ''"
//		),
	)
);

/**
 * Provide miscellaneous methods that are used by the data configuration array.
 *
 * @author Leo Feyer <https://github.com/leofeyer>
 */
class tl_docs extends \Backend
{
	/**
	 * Import the back end user object
	 */
	public function __construct()
	{
		parent::__construct();
		$this->import('\BackendUser', 'User');
	}

	/**
	 * Check permissions to edit table tl_docs
	 */
	public function checkPermission()
	{
		$bundles = \System::getContainer()->getParameter('kernel.bundles');

		if ($this->User->isAdmin)
		{
			return;
		}

		// Set the root IDs
		if (empty($this->User->dzdocss) || !is_array($this->User->dzdocss))
		{
			$root = array(0);
		}
		else
		{
			$root = $this->User->dzdocss;
		}

		$id = strlen(\Input::get('id')) ? \Input::get('id') : CURRENT_ID;

		// Check current action
		switch (\Input::get('act'))
		{
			case 'paste':
			case 'select':
				// Check CURRENT_ID here (see #247)
				if (!in_array(CURRENT_ID, $root))
				{
					throw new \CoreBundle\Exception\AccessDeniedException('Not enough permissions to access DOCS category ID ' . $id . '.');
				}
				break;

			case 'create':
				if (!strlen(\Input::get('pid')) || !in_array(\Input::get('pid'), $root))
				{
					throw new \CoreBundle\Exception\AccessDeniedException('Not enough permissions to create DOCSs in DOCS category ID ' . \Input::get('pid') . '.');
				}
				break;

			case 'cut':
			case 'copy':
				if (\Input::get('act') == 'cut' && \Input::get('mode') == 1)
				{
					$objDocs = $this->Database->prepare("SELECT pid FROM tl_docs WHERE id=?")
											 ->limit(1)
											 ->execute(\Input::get('pid'));

					if ($objDocs->numRows < 1)
					{
						throw new \CoreBundle\Exception\AccessDeniedException('Invalid DOCS ID ' . \Input::get('pid') . '.');
					}

					$pid = $objDocs->pid;
				}
				else
				{
					$pid = \Input::get('pid');
				}

				if (!in_array($pid, $root))
				{
					throw new \CoreBundle\Exception\AccessDeniedException('Not enough permissions to ' . \Input::get('act') . ' DOCS ID ' . $id . ' to DOCS category ID ' . $pid . '.');
				}
				// no break

			case 'edit':
			case 'show':
			case 'delete':
			case 'toggle':
				$objDocs = $this->Database->prepare("SELECT pid FROM tl_docs WHERE id=?")
										 ->limit(1)
										 ->execute($id);

				if ($objDocs->numRows < 1)
				{
					throw new \CoreBundle\Exception\AccessDeniedException('Invalid DOCS ID ' . $id . '.');
				}

				if (!in_array($objDocs->pid, $root))
				{
					throw new \CoreBundle\Exception\AccessDeniedException('Not enough permissions to ' . \Input::get('act') . ' DOCS ID ' . $id . ' of DOCS category ID ' . $objDocs->pid . '.');
				}
				break;

			case 'editAll':
			case 'deleteAll':
			case 'overrideAll':
			case 'cutAll':
			case 'copyAll':
				if (!in_array($id, $root))
				{
					throw new \CoreBundle\Exception\AccessDeniedException('Not enough permissions to access DOCS category ID ' . $id . '.');
				}

				$objDocs = $this->Database->prepare("SELECT id FROM tl_docs WHERE pid=?")
										 ->execute($id);

				/** @var Symfony\Component\HttpFoundation\Session\SessionInterface $objSession */
				$objSession = \System::getContainer()->get('session');

				$session = $objSession->all();
				$session['CURRENT']['IDS'] = array_intersect((array) $session['CURRENT']['IDS'], $objDocs->fetchEach('id'));
				$objSession->replace($session);
				break;

			default:
				if (strlen(\Input::get('act')))
				{
					throw new \CoreBundle\Exception\AccessDeniedException('Invalid command "' . \Input::get('act') . '".');
				}

				if (!in_array($id, $root))
				{
					throw new \CoreBundle\Exception\AccessDeniedException('Not enough permissions to access DOCS category ID ' . $id . '.');
				}
				break;
		}
	}

	/**
	 * Auto-generate the DOCS alias if it has not been set yet
	 *
	 * @param mixed                $varValue
	 * @param \DataContainer $dc
	 *
	 * @return mixed
	 *
	 * @throws Exception
	 */
	public function generateAlias($varValue, \DataContainer $dc)
	{
		$aliasExists = function (string $alias) use ($dc): bool
		{
			return $this->Database->prepare("SELECT id FROM tl_docs WHERE alias=? AND id!=?")->execute($alias, $dc->id)->numRows > 0;
		};

		// Generate alias if there is none
		if ($varValue == '')
		{
			$varValue = \System::getContainer()->get('contao.slug')->generate($dc->activeRecord->title, \Dmkzwo\ContaoDocsBundle\Model\DocsCategoryModel::findByPk($dc->activeRecord->pid)->jumpTo, $aliasExists);
		}
		elseif ($aliasExists($varValue))
		{
			throw new Exception(sprintf($GLOBALS['TL_LANG']['ERR']['aliasExists'], $varValue));
		}

		return $varValue;
	}

	/**
	 * Add the type of input field
	 *
	 * @param array $arrRow
	 *
	 * @return string
	 */
	public function listTitles($arrRow)
	{
		$key = $arrRow['published'] ? 'published' : 'unpublished';
		$date = \Date::parse(\Config::get('datimFormat'), $arrRow['tstamp']);

		return $arrRow['title'] . "\n";
//		return '
//<div class="cte_type ' . $key . '">' . $date . '</div>
//<div class="limit_height' . (!\Config::get('doNotCollapse') ? ' h40' : '') . '">
//<h2>' . $arrRow['question'] . '</h2>
//' . \StringUtil::insertTagToSrc($arrRow['answer']) . '
//</div>' . "\n";
	}

	/**
	 * Return the "toggle visibility" button
	 *
	 * @param array  $row
	 * @param string $href
	 * @param string $label
	 * @param string $title
	 * @param string $icon
	 * @param string $attributes
	 *
	 * @return string
	 */
	public function toggleIcon($row, $href, $label, $title, $icon, $attributes)
	{
		if (\Input::get('tid'))
		{
			$this->toggleVisibility(\Input::get('tid'), (\Input::get('state') == 1), (@func_get_arg(12) ?: null));
			$this->redirect($this->getReferer());
		}

		// Check permissions AFTER checking the tid, so hacking attempts are logged
		if (!$this->User->hasAccess('tl_docs::published', 'alexf'))
		{
			return '';
		}

		$href .= '&amp;tid=' . $row['id'] . '&amp;state=' . ($row['published'] ? '' : 1);

		if (!$row['published'])
		{
			$icon = 'invisible.svg';
		}

		return '<a href="' . $this->addToUrl($href) . '" title="' . \StringUtil::specialchars($title) . '"' . $attributes . '>' . \Image::getHtml($icon, $label, 'data-state="' . ($row['published'] ? 1 : 0) . '"') . '</a> ';
	}

	/**
	 * Disable/enable a user group
	 *
	 * @param integer              $intId
	 * @param boolean              $blnVisible
	 * @param \DataContainer $dc
	 *
	 * @throws \CoreBundle\Exception\AccessDeniedException
	 */
	public function toggleVisibility($intId, $blnVisible, \DataContainer $dc=null)
	{
		// Set the ID and action
		\Input::setGet('id', $intId);
		\Input::setGet('act', 'toggle');

		if ($dc)
		{
			$dc->id = $intId; // see #8043
		}

		// Trigger the onload_callback
		if (is_array($GLOBALS['TL_DCA']['tl_docs']['config']['onload_callback']))
		{
			foreach ($GLOBALS['TL_DCA']['tl_docs']['config']['onload_callback'] as $callback)
			{
				if (is_array($callback))
				{
					$this->import($callback[0]);
					$this->{$callback[0]}->{$callback[1]}($dc);
				}
				elseif (is_callable($callback))
				{
					$callback($dc);
				}
			}
		}

		// Check the field access
		if (!$this->User->hasAccess('tl_docs::published', 'alexf'))
		{
			throw new \CoreBundle\Exception\AccessDeniedException('Not enough permissions to publish/unpublish DOCS ID ' . $intId . '.');
		}

		// Set the current record
		if ($dc)
		{
			$objRow = $this->Database->prepare("SELECT * FROM tl_docs WHERE id=?")
									 ->limit(1)
									 ->execute($intId);

			if ($objRow->numRows)
			{
				$dc->activeRecord = $objRow;
			}
		}

		$objVersions = new \Versions('tl_docs', $intId);
		$objVersions->initialize();

		// Trigger the save_callback
		if (is_array($GLOBALS['TL_DCA']['tl_docs']['fields']['published']['save_callback']))
		{
			foreach ($GLOBALS['TL_DCA']['tl_docs']['fields']['published']['save_callback'] as $callback)
			{
				if (is_array($callback))
				{
					$this->import($callback[0]);
					$blnVisible = $this->{$callback[0]}->{$callback[1]}($blnVisible, $dc);
				}
				elseif (is_callable($callback))
				{
					$blnVisible = $callback($blnVisible, $dc);
				}
			}
		}

		$time = time();

		// Update the database
		$this->Database->prepare("UPDATE tl_docs SET tstamp=$time, published='" . ($blnVisible ? '1' : '') . "' WHERE id=?")
					   ->execute($intId);

		if ($dc)
		{
			$dc->activeRecord->tstamp = $time;
			$dc->activeRecord->published = ($blnVisible ? '1' : '');
		}

		// Trigger the onsubmit_callback
		if (is_array($GLOBALS['TL_DCA']['tl_docs']['config']['onsubmit_callback']))
		{
			foreach ($GLOBALS['TL_DCA']['tl_docs']['config']['onsubmit_callback'] as $callback)
			{
				if (is_array($callback))
				{
					$this->import($callback[0]);
					$this->{$callback[0]}->{$callback[1]}($dc);
				}
				elseif (is_callable($callback))
				{
					$callback($dc);
				}
			}
		}

		$objVersions->create();
	}
}
