<?php


namespace Dmkzwo\ContaoDocsBundle\Module;




use Dmkzwo\ContaoDocsBundle\Library\DocsHelper;
use Dmkzwo\ContaoDocsBundle\Model\DocsModel;

class DocsListModule extends \Module
{
    protected $strTemplate = 'mod_dz_docslist';
    protected $baseCssClass = 'mod_dzdocslist';

    protected $perPage = 10;

    public function generate()
    {
        if (TL_MODE === 'BE') {
            $template = new \BackendTemplate('be_wildcard');

            $template->wildcard = '### ' . strtoupper($GLOBALS['TL_LANG']['FMD']['dzdocslist'][0]) . ' ###';

            return $template->parse();
        }

        $this->dzDocCategories = \StringUtil::deserialize($this->dzDocCategories);

        return parent::generate();
    }

    protected function compile()
    {
        // $this->addAssets();

        $activeLanguage = $GLOBALS['TL_LANGUAGE'];

        $searchStr = $this->getSearchParam();
        $this->Template->searchStr = $searchStr;

        $activeOrder = $this->getOrderParam();
        $orderOptions = DocsHelper::getOrderOptions($activeOrder);
        $this->Template->orderOptions = $orderOptions;

        $objsDocs = DocsModel::searchByParams($this->dzDocCategories, $searchStr, $activeOrder);

        if ($objsDocs) {
            $objsDocs = $objsDocs->fetchAll();

            // Pagination
            $total = sizeof($objsDocs);
            $this->Template->total = $total;

            if ($total > 0) {
                if ($this->perPage > 0) {

                    $page = \Input::get('page') ?: 1;

                    if ($page < 1 || $page > ceil($total/$this->perPage)) {
                        $page = 1;
                    }

                    $offset = ($page - 1) * $this->perPage;

                    $objPagination = new \Pagination($total, $this->perPage);
                    $this->Template->pagination = $objPagination->generate("\n ");

                    $objsDocs = array_slice($objsDocs, $offset, $this->perPage);
                }
            }

        }


        $this->Template->docs = $objsDocs;
        $this->Template->lang = $activeLanguage;

        $this->Template->baseCssClass = $this->baseCssClass;
        $this->Template->genericCssClass = 'result';

    }

    protected function getSearchParam() {
        $searchParam = \Input::get('s');

        return $searchParam;
    }

    protected function getOrderParam() {
        $param = \Input::get('ord');

        if (!in_array($param, DocsHelper::getOrderKeys())) {
            return '';
        }

        return $param;
    }

}
