<?php

namespace Dmkzwo\ContaoDocsBundle\Model;


class DocsModel extends \Model
{

    protected static $strTable = 'tl_docs';

    /**
     * Find a published FAQ from one or more categories by its ID or alias
     *
     * @param mixed $varId The numeric ID or alias name
     * @param array $arrPids An array of parent IDs
     * @param array $arrOptions An optional options array
     *
     * @return FaqModel|null The model or null if there is no FAQ
     */
    public static function findPublishedByParentAndIdOrAlias($varId, $arrPids, array $arrOptions = array())
    {
        if (empty($arrPids) || !\is_array($arrPids)) {
            return null;
        }

        $t = static::$strTable;
        $arrColumns = !preg_match('/^[1-9]\d*$/', $varId) ? array("$t.alias=?") : array("$t.id=?");
        $arrColumns[] = "$t.pid IN(" . implode(',', array_map('\intval', $arrPids)) . ")";

        if (!static::isPreviewMode($arrOptions)) {
            $arrColumns[] = "$t.published='1'";
        }

        return static::findOneBy($arrColumns, $varId, $arrOptions);
    }

    /**
     * Find all published FAQs by their parent ID
     *
     * @param int $intPid The parent ID
     * @param array $arrOptions An optional options array
     *
     * @return Collection|FaqModel[]|FaqModel|null A collection of models or null if there are no FAQs
     */
    public static function findPublishedByPid($intPid, array $arrOptions = array())
    {
        $t = static::$strTable;
        $arrColumns = array("$t.pid=?");

        if (!static::isPreviewMode($arrOptions)) {
            $arrColumns[] = "$t.published='1'";
        }

        if (!isset($arrOptions['order'])) {
            $arrOptions['order'] = "$t.sorting";
        }

        return static::findBy($arrColumns, $intPid, $arrOptions);
    }

    /**
     * Find all published FAQs by their parent IDs
     *
     * @param array $arrPids An array of FAQ category IDs
     * @param array $arrOptions An optional options array
     *
     * @return Collection|FaqModel[]|FaqModel|null A collection of models or null if there are no FAQs
     */
    public static function findPublishedByPids($arrPids, array $arrOptions = array())
    {
        if (empty($arrPids) || !\is_array($arrPids)) {
            return null;
        }

        $t = static::$strTable;
        $arrColumns = array("$t.pid IN(" . implode(',', array_map('\intval', $arrPids)) . ")");

        if (!static::isPreviewMode($arrOptions)) {
            $arrColumns[] = "$t.published='1'";
        }

        if (!isset($arrOptions['order'])) {
            $arrOptions['order'] = "$t.pid, $t.sorting";
        }

        return static::findBy($arrColumns, null, $arrOptions);
    }

    public static function searchByParams($arrPids, $searchStr, $order)
    {
        if (empty($arrPids) || !\is_array($arrPids)) {
            return null;
        }

        if ($order == 'za') {
            $orderBy = 'title DESC';
        } else {
            $orderBy = 'title ASC';
        }

        $values = [];

        $t = static::$strTable;
        $columns = array("$t.pid IN(" . implode(',', array_map('\intval', $arrPids)) . ")");

        if (!empty($searchStr)) {
            $columns[] = "(title LIKE ? OR publisher LIKE ? OR version LIKE ? OR infoText LIKE ?)";
            $values[] = "%" . $searchStr . "%";
            $values[] = "%" . $searchStr . "%";
            $values[] = "%" . $searchStr . "%";
            $values[] = "%" . $searchStr . "%";
        }

        if (sizeof($columns)) {
            $docs = self::findBy(
                $columns,
                $values,
                [
                    'order' => $orderBy
                ]
            );
        } else {
            $docs = self::findAll(
                [
                    'order' => $orderBy
                ]
            );
        }

        return $docs;

    }


}

class_alias(DocsModel::class, 'DocsModel');
