<?php


namespace Dmkzwo\ContaoDocsBundle\Library;


use Dmkzwo\ContaoDocsBundle\Model\DocsModel;
use Patchwork\Utf8;
use Dmkzwo\ContaoDocsBundle\Model\DocsCategoryModel;

/**
 * Class DocsHelper
 * @package Dmkzwo\ContaoDocsBundle\Library
 */
class DocsHelper extends \Frontend
{


    /**
     * @param string $strTag
     * @return false|mixed|string|null
     */
    public function myReplaceInsertTags(string $strTag)
    {
        $arrSplit = explode('::', $strTag);

        if ($arrSplit[0] == 'doc_url') {
            if (!$arrSplit[1]) {
                return '';
            }

            return self::generateDocLinkById($arrSplit[1]);
        }

        if ($arrSplit[0] == 'doc_title') {
            if (!$arrSplit[1]) {
                return '';
            }

            $objDoc = DocsModel::findByPk($arrSplit[1]);

            if ($objDoc) {
                return $objDoc->title;
            }

            return '';
        }

        if ($arrSplit[0] == 'doc_type') {
            if (!$arrSplit[1]) {
                return '';
            }

            return $GLOBALS['TL_LANG']['dz_docs']['doctype'][$arrSplit[1]];
        }

        if ($arrSplit[0] == 'doc_file_url') {
            if (!$arrSplit[1]) {
                return '';
            }

            $file = self::getDocFile($arrSplit[1]);

            if ($file) {
                return $file['src'];
            }

            return '';
        }

        if ($arrSplit[0] == 'doc_file_name') {
            if (!$arrSplit[1]) {
                return '';
            }

            $file = self::getDocFile($arrSplit[1]);

            if ($file) {
                return $file['name'];
            }

            return '';
        }

        if ($arrSplit[0] == 'doc_file_size') {
            if (!$arrSplit[1]) {
                return '';
            }

            $file = self::getDocFile($arrSplit[1]);

            if ($file) {
                $fileSize = filesize(\System::getContainer()->getParameter('kernel.project_dir') . '/' . $file['src']);
                return self::humanReadableFilesize($fileSize, 1) . 'B';
            }

            return '';
        }

        if ($arrSplit[0] == 'doc_file_namemeta') {
            if (!$arrSplit[1]) {
                return '';
            }

            $file = self::getDocFile($arrSplit[1]);

            if ($file) {
                $name = $file['name'];

                $suffix = strtoupper(self::getSuffix($file['src']));

                $name = sprintf($GLOBALS['TL_LANG']['dz_docs']['save_as'], ucfirst($suffix));

                $fileSize = filesize(\System::getContainer()->getParameter('kernel.project_dir') . '/' . $file['src']);
                $hrfileSize = self::humanReadableFilesize($fileSize, 1) . 'B';

//                return sprintf("%s (%s, %s)", $name, $suffix, $hrfileSize);
                return sprintf("%s (%s)", $name, $hrfileSize);
            }

            return '';
        }

        if ($arrSplit[0] == 'doc_file_titlemeta') {
            if (!$arrSplit[1]) {
                return '';
            }

            $objDoc = DocsModel::findByPk($arrSplit[1]);

            if ($objDoc) {
                $file = self::getDocFile($arrSplit[1]);

                if ($file) {
                    $suffix = strtoupper(self::getSuffix($file['src']));
                    $fileSize = filesize(\System::getContainer()->getParameter('kernel.project_dir') . '/' . $file['src']);
                    $hrfileSize = self::humanReadableFilesize($fileSize, 1) . 'B';

                    return sprintf("%s (%s, %s)", $objDoc->title, $suffix, $hrfileSize);
                }
            }

            return '';
        }

        if ($arrSplit[0] == 'doc_download_meta') {
            if (!$arrSplit[1]) {
                return '';
            }

            $file = self::getDocFile($arrSplit[1]);

            if ($file) {
                $name = $file['name'];
                $suffix = strtoupper(self::getSuffix($file['src']));
                $fileSize = filesize(\System::getContainer()->getParameter('kernel.project_dir') . '/' . $file['src']);
                $hrfileSize = self::humanReadableFilesize($fileSize, 1) . 'B';

                return sprintf($GLOBALS['TL_LANG']['dz_docs']['save_as'] . " (%s)", $suffix, $hrfileSize);
            }

            return '';
        }

        return false; // this is important!!!

    }

    public static function getSuffix($fileName) {
        return substr($fileName, strrpos($fileName, '.')+1);
    }

    public static function generateDocLinkById($docId)
    {
        $objDoc = DocsModel::findByPk($docId);

        if ($objDoc) {
            return self::generateDocLink($objDoc);
        }

        return '';
    }

    /**
     * @param DocsModel $objDoc
     * @return string
     */
    public static function generateDocLink($objDoc)
    {
        $objCategory = DocsCategoryModel::findByPk($objDoc->pid);
        $jumpTo = (int)$objCategory->jumpTo;

        // A jumpTo page is not mandatory for FAQ categories (see #6226) but required for the FAQ list module
//        if ($jumpTo < 1)
//        {
//            throw new \Exception("FAQ categories without redirect page cannot be used in an FAQ list");
//        }

        // Get the URL from the jumpTo page of the category
        $arrTargets = [];

        if (!isset($arrTargets[$jumpTo])) {
            $arrTargets[$jumpTo] = ampersand(\Environment::get('request'));

            if ($jumpTo > 0 && ($objTarget = \PageModel::findByPk($jumpTo)) !== null) {
                /** @var PageModel $objTarget */
                $arrTargets[$jumpTo] = ampersand($objTarget->getFrontendUrl(\Config::get('useAutoItem') ? '/%s' : '/items/%s'));
            }
        }

        return sprintf(preg_replace('/%(?!s)/', '%%', $arrTargets[$jumpTo]), ($objDoc->alias ?: $objDoc->id));
    }

    public static function addCoverImage($doc)
    {
        if ($doc['addCover']) {
            $image = [];

            if ($doc['coverSRC']) {
                $image = self::addImage($doc['coverSRC']);
            } else {
                $image = self::addDefaultImage($doc, 'cover', $image);
            }

            if ($image['src']) {
                $doc['cover'] = $image;
            } else {
                $doc['addCover'] = '';
            }
        }

        return $doc;
    }

    public static function addTeaserImage($doc)
    {
//        if ($doc['addTeaserImage']) {
            $image = [];

            if ($doc['teaserImageSRC']) {
                $image = self::addImage($doc['teaserImageSRC']);
            } else {
                $image = self::addDefaultImage($doc, 'teaser', $image);
            }

            if ($image['src']) {
                $doc['teaser'] = $image;
            } else {
                $doc['addTeaserImage'] = '';
            }
//        }

        return $doc;
    }

    protected static function addDefaultImage($doc, $imageType, array $image): array
    {
        $defaultImgPath = \System::getContainer()->getParameter('ww.docs_' . $imageType . '_default_dir') . '/' . $doc['docType'] . '.png';
        if (is_file(\System::getContainer()->getParameter('kernel.project_dir') . '/' . $defaultImgPath)) {
            $image['src'] = $defaultImgPath;
        }
        return $image;
    }

    protected static function addImage($imageSrc): array
    {
        $objModel = \FilesModel::findByUuid($imageSrc);
        if ($objModel !== null && is_file(\System::getContainer()->getParameter('kernel.project_dir') . '/' . $objModel->path)) {
            $image = $objModel->row();
            $image['src'] = $objModel->path;
        }
        return $image;
    }

    public static function getDocFile($docId)
    {
        $objDoc = DocsModel::findByPk($docId);

        if ($objDoc) {
            $objModel = \FilesModel::findByUuid($objDoc->fileSRC);
            if ($objModel !== null && is_file(\System::getContainer()->getParameter('kernel.project_dir') . '/' . $objModel->path)) {
                $file = $objModel->row();
                $file['src'] = $objModel->path;

            }
            return $file;
        }

        return false;
    }


    public function getSearchablePages($arrPages, $intRoot = 0, $blnIsSitemap = false)
    {
        $arrRoot = array();

        if ($intRoot > 0) {
            $arrRoot = $this->Database->getChildRecords($intRoot, 'tl_page');
        }

        $arrProcessed = array();
        $time = \Date::floorToMinute();

        // Get all categories
        $objDocs = DocsCategoryModel::findAll();

        // Walk through each category
        if ($objDocs !== null) {
            while ($objDocs->next()) {
                // Skip Docs without target page
                if (!$objDocs->jumpTo) {
                    continue;
                }

                // Skip Docs outside the root nodes
                if (!empty($arrRoot) && !\in_array($objDocs->jumpTo, $arrRoot)) {
                    continue;
                }

                // Get the URL of the jumpTo page
                if (!isset($arrProcessed[$objDocs->jumpTo])) {
                    $objParent = \PageModel::findWithDetails($objDocs->jumpTo);

                    // The target page does not exist
                    if ($objParent === null) {
                        continue;
                    }

                    // The target page has not been published (see #5520)
                    if (!$objParent->published || ($objParent->start != '' && $objParent->start > $time) || ($objParent->stop != '' && $objParent->stop <= ($time + 60))) {
                        continue;
                    }

                    if ($blnIsSitemap) {
                        // The target page is protected (see #8416)
                        if ($objParent->protected) {
                            continue;
                        }

                        // The target page is exempt from the sitemap (see #6418)
                        if ($objParent->robots == 'noindex,nofollow') {
                            continue;
                        }
                    }

                    // Generate the URL
                    $arrProcessed[$objDocs->jumpTo] = $objParent->getAbsoluteUrl(\Config::get('useAutoItem') ? '/%s' : '/items/%s');
                }

                $strUrl = $arrProcessed[$objDocs->jumpTo];

                // Get the items
                $objItems = DocsModel::findPublishedByPid($objDocs->id);

                if ($objItems !== null) {
                    while ($objItems->next()) {
                        $arrPages[] = sprintf(preg_replace('/%(?!s)/', '%%', $strUrl), ($objItems->alias ?: $objItems->id));
                    }
                }
            }
        }

        return $arrPages;
    }

    public static function getOrderKeys()
    {
        return ['az', 'za'];
    }

    public static function getOrderOptions($activeKey)
    {
        $availableOrderKeys = self::getOrderKeys();

        $options = [];

        foreach ($availableOrderKeys as $availableOrderKey) {
            $selected = ($availableOrderKey == $activeKey) ? 'selected="selected"' : '';
            $option = sprintf('<option value="%s" %s>%s</option>', $availableOrderKey, $selected, $GLOBALS['TL_LANG']['dz_sdg']['order'][$availableOrderKey]);
            $options[] = $option;
        }

        return implode("\n", $options);

    }

    public static function humanReadableFilesize($bytes, $decimals = 2)
    {
        $sz = 'BKMGTP';
        $factor = floor((strlen($bytes) - 1) / 3);
        return sprintf("%.{$decimals}f", $bytes / pow(1024, $factor)) . ' ' . @$sz[$factor];
    }
}
