<?php

namespace Dmkzwo\ContaoDocsBundle\Elements;


use Dmkzwo\ContaoDocsBundle\Library\DocsHelper;
use Dmkzwo\ContaoDocsBundle\Model\DocsCategoryModel;
use Dmkzwo\ContaoDocsBundle\Model\DocsModel;

class ContentDocsCluster extends \ContentElement
{

    protected $strTemplate = 'ce_dzdocscluster';
    protected $baseCssClass = 'ce_dzdocscluster';

    public function generate()
    {
//        if (file_exists(TL_ROOT . '/templates/ww_theme/ce_dzfaq_selection_' . $this->dzSubtype . '.html5')) {
//            $this->strTemplate = 'ce_dzfaq_selection_' . $this->dzSubtype;
//        }

        return parent::generate();
    }

    protected function compile()
    {

        if (TL_MODE == 'BE') {
            $this->Template = new \BackendTemplate('be_wildcard');
            $this->Template->wildcard = '### DOCS CLUSTER ###';
            $this->Template->title = $this->headline;

            return;
        }

        $docs = [];
        $docsArr = \StringUtil::deserialize($this->dzDocs);

        foreach ($docsArr as $docItem) {

            $docId = $docItem['doc_id'];

//            DocsHelper::getDocFile($docId);

            $docObj = DocsModel::findByPk($docId);

            if ($docObj && $docObj->published) {
                $doc = $docObj->row();

                $doc['jumpTo'] = DocsHelper::generateDocLink($docObj);
                $doc = DocsHelper::addTeaserImage($doc);

                $docs[] = $doc;


            }

        }

        $this->Template->docs = $docs;

//        $faqs = [];
//
//        foreach ($faqArr as $faqItem) {
//            $faqId = $faqItem['faq_id'];
//
//            $faqObj = \FaqModel::findByPk($faqId);
//
//            if ($faqObj && $faqObj->published) {
//                $faqArr = $faqObj->row();
//
//                $faqArr['addcss'] = (!empty($faqItem['faq_css'])) ? $this->baseCssClass . '__question--' . $faqItem['faq_css'] : '';
//
//                $faqArr['question'] = (!empty($faqArr['dzQuestionShort'])) ? $faqArr['dzQuestionShort'] : $faqArr['question'];
//
//                $faqs[] = $faqArr;
//            }
//        }
//
//        $this->Template->faqPages = $faqPages;


        $this->Template->baseCssClass = $this->baseCssClass;

    }
}

class_alias(ContentDocsCluster::class, 'ContentDzDocsCluster');
