<?php

namespace Dmkzwo\ContaoDocsBundle\Elements;


use Dmkzwo\ContaoDocsBundle\Library\DocsHelper;
use Dmkzwo\ContaoDocsBundle\Model\DocsCategoryModel;
use Dmkzwo\ContaoDocsBundle\Model\DocsModel;

class ContentDocTeaser extends \ContentElement
{

    protected $strTemplate = 'ce_dzdoc_teaser';
    protected $baseCssClass = 'ce_dzdocteaser';

    public function generate()
    {
//        if (file_exists(TL_ROOT . '/templates/ww_theme/ce_dzfaq_selection_' . $this->dzSubtype . '.html5')) {
//            $this->strTemplate = 'ce_dzfaq_selection_' . $this->dzSubtype;
//        }

        return parent::generate();
    }

    protected function compile()
    {

        if (TL_MODE == 'BE') {
            $this->Template = new \BackendTemplate('be_wildcard');
            $this->Template->wildcard = '### DOC TEASER ###';
//            $this->Template->title = $this->dzDocsHeadline;

            return;
        }


        $docObj = DocsModel::findByPk($this->dzDoc);

        if ($docObj && $docObj->published) {
            $doc = $docObj->row();

            $doc['jumpTo'] = DocsHelper::generateDocLink($docObj);
            $doc = DocsHelper::addTeaserImage($doc);

            $docs[] = $doc;

        }


        $this->Template->doc = $doc;

        $this->Template->baseCssClass = $this->baseCssClass;

    }
}

class_alias(ContentDocTeaser::class, 'ContentDzDocTeaser');
