<?php

namespace Dmkzwo\ContaoDocsBundle\Classes;


use Dmkzwo\ContaoDocsBundle\Model\DocsModel;

class DocsDca
{

    public static function getLanguageBackendOptions()
    {
        $options = [
            'de' => 'Deutsch',
            'en' => 'Englisch',
            'fr' => 'Französisch',
            'es' => 'Spanisch',
        ];

        return $options;
    }

    public function getDoctypeBackendOptions()
    {
        $options = [
            'pub' => 'Publikation',
            'form' => 'Formular',
        ];

        return $options;
    }

    public function getDocsBackendOptions()
    {
        $options = [];

        $docs = DocsModel::findBy('published', '1', ['order' => 'title']);

        $options[''] = 'Dokument wählen';

        foreach ($docs as $doc) {
            $options[$doc->id] = $doc->title;
        }

        return $options;
    }


}
